<?php

namespace App\Http\Controllers\Api;

use App\Models\Answer;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;

class AnswerController extends Controller
{
   
    public function listAnswer(Request $resquest)
    {
        $perPage = $resquest->input('per_page', 10);

        $answer = Answer::paginate($perPage);


        if ($answer->isEmpty()) {
            return response()->json(['message' => 'No se encuentran las respuestas de comentarios'], Response::HTTP_NOT_FOUND);
        }
        return response()->json([$answer], Response::HTTP_OK);
    }
  
    public function showAnswer($id_answer)

    {
        $answer = Answer::find($id_answer);
        if (!$answer) {


            return response()->json(
                ['message' => 'No se encontro la respuesta'],
                Response::HTTP_NOT_FOUND
            );
        }


        return response()->json(
            ['message' => $answer],
            Response::HTTP_OK
        );
    }

    public function RegisterAnswer(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'coment' => 'required',
            'answer_status' => 'required',
            'external_user_id' => 'required',
            'id_feedback' => 'required'
        ]);



        if ($validator->fails()) {
            return response()->json(['message' => 'Error al crear la respuesta', 'errors' => $validator->errors()], Response::HTTP_BAD_REQUEST);
        }


        $answer = Answer::create([
            'coment' => $request->coment,
            'answer_status' => $request->answer_status,
            'external_user_id' => $request->external_user_id,
            'id_feedback' => $request->id_feedback
        ]);

        if (!$answer) {
            return response()->json(['message' => 'Error al generar la respuesta'], Response::HTTP_BAD_REQUEST);
        }
        return response()->json([
            'message' => 'respuesta generada correctamente',
            'data' => $answer
        ], Response::HTTP_CREATED);
    }

  
    public function UpgradePartialAnswer(Request $request, $id_answer)
    {
       
    $answer = Answer::find($id_answer);
    if (!$answer) {
        
        return response()->json(
            ['message' => 'No se encontró la respuesta'],
            Response::HTTP_NOT_FOUND
        );
    }

    $validator = Validator::make($request->all(), [
            'coment' => 'sometimes|string',
            'answer_status' => 'sometimes|string',
            'id_feedback' => 'sometimes',
            'external_user_id' => 'sometimes'
    ]);

    if ($validator->fails()) {
        return response()->json(
            [
                'message' => 'Error al actualizar la respuesta',
                'errors' => $validator->errors(),
            ],
            Response::HTTP_BAD_REQUEST
        );
    }

    // Validar campos vacíos
    $errors = [];
    $fields = [
        'coment',
        'answer_status',
        'id_feedback',
        'external_user_id'
    ];

    foreach ($fields as $field) {
        if ($request->has($field) ){
            if (empty($request->$field)) {
                $errors[$field] = 'El campo ' . $field . ' no puede estar vacío.';
            }
        }
    }

    if (!empty($errors)) {
        return response()->json(
            [
                'message' => 'Error al actualizar la respuesta: campos vacíos',
                'errors' => $errors,
            ],
            Response::HTTP_BAD_REQUEST
        );
    }

    $dataToUpdate = array_filter($request->only([
       'coment',
        'answer_status',
        'id_feedback',
        'external_user_id'
    ]), function ($value) {
        return !empty($value); 
    });

    $answer->fill($dataToUpdate);
    $answer->save();

   
    return response()->json(
        [
            'message' => 'respuesta actualizada correctamente',
            'data' => $answer,
        ],
        Response::HTTP_OK);
}
}
